/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ColorModel;

public class PixelConverter {
    public static final PixelConverter instance = new PixelConverter();
    protected int alphaMask = 0;

    public final int getAlphaMask() {
        return this.alphaMask;
    }

    protected PixelConverter() {
    }

    public int pixelToRgb(int n2, ColorModel colorModel) {
        return n2;
    }

    public int rgbToPixel(int n2, ColorModel colorModel) {
        Object object = colorModel.getDataElements(n2, null);
        switch (colorModel.getTransferType()) {
            case 0: {
                byte[] byArray = (byte[])object;
                int n3 = 0;
                switch (byArray.length) {
                    default: {
                        n3 = byArray[3] << 24;
                    }
                    case 3: {
                        n3 |= (byArray[2] & 0xFF) << 16;
                    }
                    case 2: {
                        n3 |= (byArray[1] & 0xFF) << 8;
                    }
                    case 1: 
                }
                return n3 |= byArray[0] & 0xFF;
            }
            case 1: 
            case 2: {
                short[] sArray = (short[])object;
                return (sArray.length > 1 ? sArray[1] << 16 : 0) | sArray[0] & 0xFFFF;
            }
            case 3: {
                return ((int[])object)[0];
            }
        }
        return n2;
    }

    static class 1 {
    }

    public static class Argb
    extends PixelConverter {
        public static final PixelConverter instance = new Argb();

        private Argb() {
            this.alphaMask = -16777216;
        }

        public int pixelToRgb(int n2, ColorModel colorModel) {
            return n2;
        }

        public int rgbToPixel(int n2, ColorModel colorModel) {
            return n2;
        }
    }

    public static class ArgbBm
    extends PixelConverter {
        public static final PixelConverter instance = new ArgbBm();

        private ArgbBm() {
        }

        public int pixelToRgb(int n2, ColorModel colorModel) {
            return n2 << 7 >> 7;
        }

        public int rgbToPixel(int n2, ColorModel colorModel) {
            return n2 | n2 >> 31 << 24;
        }
    }

    public static class ArgbPre
    extends PixelConverter {
        public static final PixelConverter instance = new ArgbPre();

        private ArgbPre() {
            this.alphaMask = -16777216;
        }

        public int pixelToRgb(int n2, ColorModel colorModel) {
            int n3 = n2 >>> 24;
            if (n3 == 255 || n3 == 0) {
                return n2;
            }
            int n4 = n2 >> 16 & 0xFF;
            int n5 = n2 >> 8 & 0xFF;
            int n6 = n2 & 0xFF;
            n4 = ((n4 << 8) - n4) / n3;
            n5 = ((n5 << 8) - n5) / n3;
            n6 = ((n6 << 8) - n6) / n3;
            return n3 << 24 | n4 << 16 | n5 << 8 | n6;
        }

        public int rgbToPixel(int n2, ColorModel colorModel) {
            if (n2 >> 24 == -1) {
                return n2;
            }
            int n3 = n2 >>> 24;
            int n4 = n2 >> 16 & 0xFF;
            int n5 = n2 >> 8 & 0xFF;
            int n6 = n2 & 0xFF;
            int n7 = n3 + (n3 >> 7);
            n4 = n4 * n7 >> 8;
            n5 = n5 * n7 >> 8;
            n6 = n6 * n7 >> 8;
            return n3 << 24 | n4 << 16 | n5 << 8 | n6;
        }
    }

    public static class Bgrx
    extends PixelConverter {
        public static final PixelConverter instance = new Bgrx();

        private Bgrx() {
        }

        public int pixelToRgb(int n2, ColorModel colorModel) {
            return 0xFF000000 | (n2 & 0xFF00) << 8 | n2 >> 8 & 0xFF00 | n2 >>> 24;
        }

        public int rgbToPixel(int n2, ColorModel colorModel) {
            return n2 << 24 | (n2 & 0xFF00) << 8 | n2 >> 8 & 0xFF00;
        }
    }

    public static class ByteGray
    extends PixelConverter {
        static final double RED_MULT = 0.299;
        static final double GRN_MULT = 0.587;
        static final double BLU_MULT = 0.114;
        public static final PixelConverter instance = new ByteGray();

        private ByteGray() {
        }

        public int pixelToRgb(int n2, ColorModel colorModel) {
            return ((0xFF00 | n2) << 8 | n2) << 8 | n2;
        }

        public int rgbToPixel(int n2, ColorModel colorModel) {
            int n3 = n2 >> 16 & 0xFF;
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 & 0xFF;
            return (int)((double)n3 * 0.299 + (double)n4 * 0.587 + (double)n5 * 0.114 + 0.5);
        }

        ByteGray(1 var1_1) {
            this();
        }
    }

    public static class Rgba
    extends PixelConverter {
        public static final PixelConverter instance = new Rgba();

        private Rgba() {
            this.alphaMask = 255;
        }

        public int pixelToRgb(int n2, ColorModel colorModel) {
            return n2 << 24 | n2 >>> 8;
        }

        public int rgbToPixel(int n2, ColorModel colorModel) {
            return n2 << 8 | n2 >>> 24;
        }
    }

    public static class RgbaPre
    extends PixelConverter {
        public static final PixelConverter instance = new RgbaPre();

        private RgbaPre() {
            this.alphaMask = 255;
        }

        public int pixelToRgb(int n2, ColorModel colorModel) {
            int n3 = n2 & 0xFF;
            if (n3 == 255 || n3 == 0) {
                return n2 >>> 8 | n2 << 24;
            }
            int n4 = n2 >>> 24;
            int n5 = n2 >> 16 & 0xFF;
            int n6 = n2 >> 8 & 0xFF;
            n4 = ((n4 << 8) - n4) / n3;
            n5 = ((n5 << 8) - n5) / n3;
            n6 = ((n6 << 8) - n6) / n3;
            return n4 << 24 | n5 << 16 | n6 << 8 | n3;
        }

        public int rgbToPixel(int n2, ColorModel colorModel) {
            if (n2 >> 24 == -1) {
                return n2 << 8 | n2 >>> 24;
            }
            int n3 = n2 >>> 24;
            int n4 = n2 >> 16 & 0xFF;
            int n5 = n2 >> 8 & 0xFF;
            int n6 = n2 & 0xFF;
            int n7 = n3 + (n3 >> 7);
            n4 = n4 * n7 >> 8;
            n5 = n5 * n7 >> 8;
            n6 = n6 * n7 >> 8;
            return n4 << 24 | n5 << 16 | n6 << 8 | n3;
        }
    }

    public static class Rgbx
    extends PixelConverter {
        public static final PixelConverter instance = new Rgbx();

        private Rgbx() {
        }

        public int pixelToRgb(int n2, ColorModel colorModel) {
            return 0xFF000000 | n2 >> 8;
        }

        public int rgbToPixel(int n2, ColorModel colorModel) {
            return n2 << 8;
        }
    }

    public static class Ushort4444Argb
    extends PixelConverter {
        public static final PixelConverter instance = new Ushort4444Argb();

        private Ushort4444Argb() {
            this.alphaMask = 61440;
        }

        public int pixelToRgb(int n2, ColorModel colorModel) {
            int n3 = n2 & 0xF000;
            n3 = (n2 << 16 | n2 << 12) & 0xFF000000;
            int n4 = n2 & 0xF00;
            n4 = (n2 << 12 | n2 << 8) & 0xFF0000;
            int n5 = n2 & 0xF0;
            n5 = (n2 << 8 | n2 << 4) & 0xFF00;
            int n6 = n2 & 0xF;
            n6 = (n2 << 4 | n2 << 0) & 0xFF;
            return n3 | n4 | n5 | n6;
        }

        public int rgbToPixel(int n2, ColorModel colorModel) {
            int n3 = n2 >> 16 & 0xF000;
            int n4 = n2 >> 12 & 0xF00;
            int n5 = n2 >> 8 & 0xF0;
            int n6 = n2 >> 4 & 0xF;
            return n3 | n4 | n5 | n6;
        }
    }

    public static class Ushort555Rgb
    extends PixelConverter {
        public static final PixelConverter instance = new Ushort555Rgb();

        private Ushort555Rgb() {
        }

        public int pixelToRgb(int n2, ColorModel colorModel) {
            int n3 = n2 >> 10 & 0x1F;
            n3 = n3 << 3 | n3 >> 2;
            int n4 = n2 >> 5 & 0x1F;
            n4 = n4 << 3 | n4 >> 2;
            int n5 = n2 & 0x1F;
            n5 = n5 << 3 | n5 >> 2;
            return 0xFF000000 | n3 << 16 | n4 << 8 | n5;
        }

        public int rgbToPixel(int n2, ColorModel colorModel) {
            return n2 >> 9 & 0x7C00 | n2 >> 6 & 0x3E0 | n2 >> 3 & 0x1F;
        }
    }

    public static class Ushort555Rgbx
    extends PixelConverter {
        public static final PixelConverter instance = new Ushort555Rgbx();

        private Ushort555Rgbx() {
        }

        public int pixelToRgb(int n2, ColorModel colorModel) {
            int n3 = n2 >> 11 & 0x1F;
            n3 = n3 << 3 | n3 >> 2;
            int n4 = n2 >> 6 & 0x1F;
            n4 = n4 << 3 | n4 >> 2;
            int n5 = n2 >> 1 & 0x1F;
            n5 = n5 << 3 | n5 >> 2;
            return 0xFF000000 | n3 << 16 | n4 << 8 | n5;
        }

        public int rgbToPixel(int n2, ColorModel colorModel) {
            return n2 >> 8 & 0xF800 | n2 >> 5 & 0x7C0 | n2 >> 2 & 0x3E;
        }
    }

    public static class Ushort565Rgb
    extends PixelConverter {
        public static final PixelConverter instance = new Ushort565Rgb();

        private Ushort565Rgb() {
        }

        public int pixelToRgb(int n2, ColorModel colorModel) {
            int n3 = n2 >> 11 & 0x1F;
            n3 = n3 << 3 | n3 >> 2;
            int n4 = n2 >> 5 & 0x3F;
            n4 = n4 << 2 | n4 >> 4;
            int n5 = n2 & 0x1F;
            n5 = n5 << 3 | n5 >> 2;
            return 0xFF000000 | n3 << 16 | n4 << 8 | n5;
        }

        public int rgbToPixel(int n2, ColorModel colorModel) {
            return n2 >> 8 & 0xF800 | n2 >> 5 & 0x7E0 | n2 >> 3 & 0x1F;
        }
    }

    public static class UshortGray
    extends ByteGray {
        static final double SHORT_MULT = 257.0;
        static final double USHORT_RED_MULT = 76.843;
        static final double USHORT_GRN_MULT = 150.85899999999998;
        static final double USHORT_BLU_MULT = 29.298000000000002;
        public static final PixelConverter instance = new UshortGray();

        private UshortGray() {
            super(null);
        }

        public int pixelToRgb(int n2, ColorModel colorModel) {
            return ((0xFF00 | (n2 >>= 8)) << 8 | n2) << 8 | n2;
        }

        public int rgbToPixel(int n2, ColorModel colorModel) {
            int n3 = n2 >> 16 & 0xFF;
            int n4 = n2 >> 8 & 0xFF;
            int n5 = n2 & 0xFF;
            return (int)((double)n3 * 76.843 + (double)n4 * 150.85899999999998 + (double)n5 * 29.298000000000002 + 0.5);
        }
    }

    public static class Xbgr
    extends PixelConverter {
        public static final PixelConverter instance = new Xbgr();

        private Xbgr() {
        }

        public int pixelToRgb(int n2, ColorModel colorModel) {
            return 0xFF000000 | (n2 & 0xFF) << 16 | n2 & 0xFF00 | n2 >> 16 & 0xFF;
        }

        public int rgbToPixel(int n2, ColorModel colorModel) {
            return (n2 & 0xFF) << 16 | n2 & 0xFF00 | n2 >> 16 & 0xFF;
        }
    }

    public static class Xrgb
    extends PixelConverter {
        public static final PixelConverter instance = new Xrgb();

        private Xrgb() {
        }

        public int pixelToRgb(int n2, ColorModel colorModel) {
            return 0xFF000000 | n2;
        }

        public int rgbToPixel(int n2, ColorModel colorModel) {
            return n2;
        }
    }
}

